package jamezo97.clonecraft.gui;

import org.lwjgl.input.Keyboard;

import jamezo97.clonecraft.entity.clone.CloneOption;
import jamezo97.clonecraft.entity.clone.CloneOptions;
import jamezo97.clonecraft.entity.clone.EntityClone;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;

public class GuiCloneOptions extends GuiScreen{

	GuiScreen parent;

	EntityClone clone;

	public GuiCloneOptions(EntityClone clone, GuiScreen parent){
		this.clone = clone;
		this.parent = parent;
	}

	int buttonWidth = 140;
	int buttonHeight = 20;
	int spacing = 5;

	int maxAccross = 0;
	int maxDown = 0;
	int maxButtons = 0;

	GuiTextField nameBox;

	@Override
	public void initGui() {
		maxAccross = (width - spacing) / (buttonWidth + spacing);
		maxDown = (height - spacing) / (buttonHeight + spacing);
		maxButtons = maxAccross * maxDown;

		CloneOptions op = clone.options;
		for(int a = 0; a < op.optionsSize(); a++){
			CloneOption option = op.getOptionByIndex(a);
			if(option != null){
				buttonList.add(new ButtonCloneOption(-100, getX(a+1), getY(a+1), buttonWidth, buttonHeight, option));
			}
		}
		buttonList.add(new GuiButton(0, getX((maxButtons-1)), getY((maxButtons-1)), buttonWidth, buttonHeight, "Done"));

		nameBox = new GuiTextField(mc.fontRenderer, getX(0), getY(0), buttonWidth, buttonHeight);
		nameBox.setText(clone.getFullEditedName());
		lastTickName = clone.getFullEditedName();
		Keyboard.enableRepeatEvents(true);
		
	}



	public int getX(int index){
		return (index / maxDown) * (buttonWidth + spacing) + spacing;
	}

	public int getY(int index){
		return (index % maxDown) * (buttonHeight + spacing) + spacing;
	}

	@Override
	public void drawScreen(int par1, int par2, float par3) {
		drawDefaultBackground();


		nameBox.drawTextBox();
		super.drawScreen(par1, par2, par3);
	}

	@Override
	protected void keyTyped(char par1, int par2) {
		if(par2 == 1){
			mc.displayGuiScreen(parent);
			if(parent == null){
				mc.setIngameFocus();
			}
		}else{
			nameBox.textboxKeyTyped(par1, par2);
		}

	}

	@Override
	protected void mouseClicked(int par1, int par2, int par3) {
		super.mouseClicked(par1, par2, par3);
		nameBox.mouseClicked(par1, par2, par3);
	}

	@Override
	protected void actionPerformed(GuiButton gb) {
		if(gb.id == 0){
			mc.displayGuiScreen(parent);
			if(parent == null){
				mc.setIngameFocus();
			}
		}
	}

	String lastTickName = "";

	@Override
	public void updateScreen() {
		if(!lastTickName.equals(nameBox.getText())){
			lastTickName = nameBox.getText();
			clone.setName(lastTickName);
			clone.sendValueToServer(EntityClone.ID_NAME);
		}else if(!nameBox.isFocused() && !nameBox.getText().equals(clone.nameUnedited)){
			nameBox.setText(clone.nameUnedited);
		}
		nameBox.updateCursorCounter();
	}

	
	
	@Override
	public void onGuiClosed() {
		Keyboard.enableRepeatEvents(false);
	}



	@Override
	public boolean doesGuiPauseGame() {
		return false;
	}


}
